% This procedure plots the impulse response functions for demand shocks
clear all
clc

path(pathdef)
addpath ./functions/

var_names   = {'a' 'u' 'p' 'prod_n' 'prod_o' 'prod_f' 'theta_n' 'theta_o' 'theta_f' ...
               'F_n' 'F_o' 'F_f' 'I_n' 'I_o' 'I_f' 'Y' 'L' 'K' 'C' 'r' 'o'};
shock_names = {'a' 'u'};


cd ./dynare_codes/

%% Get Fracking IRFs
% Need to run 'create Table_11' to obtain fracking_long_run_solution
load ../mat_files/fracking_long_run.mat

[IRF_a_f, IRF_u_f] = IRF_series_fracking(struct_param, shock_param, endo_ss);

%% Get No Fracking IRFs

load ../../../'Estimation Results'/Benchmark_Model.mat

[IRF_a, IRF_u] = IRF_series(parameters);

cd ../
%% Plot TFP Shock
time    = 1:20;
lw      = 3;
fs      = 12;
fn      = 'palatino';

hfig    = figure('color', 'w');
pos     = get(hfig,'position');
set(hfig,'position',pos.*[.5 1 2 2])

subplot(4, 4, 1), hold on
plot(time, IRF_a.a(time), 'linewidth', lw)
plot(time, IRF_a_f.a(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('A_t', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 2), hold on
plot(time, IRF_a.p(time), 'linewidth', lw)
plot(time, IRF_a_f.p(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Oil price (P)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 3), hold on
plot(time, IRF_a.o(time), 'linewidth', lw)
plot(time, IRF_a_f.o(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Oil production (O)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 4), hold on
plot(time, IRF_a.Y(time), 'linewidth', lw)
plot(time, IRF_a_f.Y(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('World GDP (Y)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 5), hold on
plot(time, [0, IRF_a.theta_n(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_f.theta_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC extraction rate (\theta)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 6), hold on
plot(time, [0, IRF_a.F_n(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_f.F_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 7), hold on
plot(time, IRF_a.I_n(time), 'linewidth', lw)
plot(time, IRF_a_f.I_n(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 8), hold on
plot(time, [0, IRF_a.X_n(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_f.X_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC exploration capital (X)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 9), hold on
plot(time, [0, IRF_a.theta_o(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_f.theta_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC extraction rate (\theta)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 10), hold on
plot(time, [0, IRF_a.F_o(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_f.F_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 11), hold on
plot(time, IRF_a.I_o(time), 'linewidth', lw)
plot(time, IRF_a_f.I_o(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 12), hold on
plot(time, [0, IRF_a.X_o(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_f.X_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC exploration capital (X)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 13), hold on
plot(time, IRF_a_f.theta_f(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Fracking extraction rate (\theta)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 14), hold on
plot(time, IRF_a_f.F_f(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Fracking oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 15), hold on
plot(time, IRF_a_f.I_f(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Fracking investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 16), hold on
plot(time(1), time(1), 'linewidth', lw)
plot(time(2), time(2), '--r', 'linewidth', lw)
set(gca, 'visible', 'off')
legend('Model w/o fracking', 'Model with Fracking', 'fontname', fn, 'fontsize', fs+4, 'fontweight', 'bold', 'location', 'east')

print('../../Figures/Figure_4','-dpng')
